/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolspower.modules.endergenic.blocks;

import java.util.HashSet;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolsbase.tools.TickOrderHandler;
import mcjty.rftoolspower.compat.RFToolsPowerTOPDriver;
import mcjty.rftoolspower.modules.endergenic.EndergenicModule;
import mcjty.rftoolspower.modules.endergenic.blocks.EndergenicTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.common.util.LazyOptional;

public class PearlInjectorTileEntity
extends TickingTileEntity
implements TickOrderHandler.IOrderTicker {
    public static final int BUFFER_SIZE = 18;
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_PLAYERINV = 18;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(18).box(SlotDefinition.specific((Item[])new Item[]{Items.f_42584_}).in(), 0, 10, 25, 9, 2).playerSlots(10, 70));
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid(GenericItemHandler.match((Item)Items.f_42584_)).build();
    @Cap(type=CapType.CONTAINER)
    private final LazyOptional<MenuProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Pearl Injector").containerSupplier(DefaultContainerProvider.container(EndergenicModule.CONTAINER_PEARL_INJECTOR, CONTAINER_FACTORY, (GenericTileEntity)this)).itemHandler(() -> this.items).setupSync((GenericTileEntity)this));
    private boolean prevIn = false;

    public static BaseBlock createBlock() {
        return new BaseBlock(new BlockBuilder().topDriver((TOPDriver)RFToolsPowerTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolspower:powergeneration/pearlinjector")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolspower.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(PearlInjectorTileEntity::new));
    }

    public PearlInjectorTileEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EndergenicModule.TYPE_PEARL_INJECTOR.get(), pos, state);
    }

    public EndergenicTileEntity findEndergenicTileEntity() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        Direction k = OrientationTools.getOrientation((BlockState)state);
        EndergenicTileEntity te = this.getEndergenicGeneratorAt(k.m_122424_());
        if (te != null) {
            return te;
        }
        return this.getEndergenicGeneratorAt(Direction.UP);
    }

    private EndergenicTileEntity getEndergenicGeneratorAt(Direction k) {
        BlockPos o = this.m_58899_().m_142300_(k);
        BlockEntity te = this.f_58857_.m_7702_(o);
        if (te instanceof EndergenicTileEntity) {
            return (EndergenicTileEntity)te;
        }
        return null;
    }

    protected void tickServer() {
        long ticker = TickOrderHandler.getTicker();
        TickOrderHandler.queue((TickOrderHandler.IOrderTicker)this);
        HashSet<BlockPos> connectedEndergenics = new HashSet<BlockPos>();
        for (EndergenicTileEntity endergenic = this.findEndergenicTileEntity(); endergenic != null && !connectedEndergenics.contains(endergenic.m_58899_()); endergenic = endergenic.getDestinationTE()) {
            if (ticker != endergenic.getTicker()) {
                endergenic.setTicker(ticker);
                TickOrderHandler.queue((TickOrderHandler.IOrderTicker)endergenic);
            }
            connectedEndergenics.add(endergenic.m_58899_());
        }
    }

    public TickOrderHandler.Rank getRank() {
        return TickOrderHandler.Rank.RANK_0;
    }

    public void tickOnServer() {
        boolean pulse = this.powerLevel > 0 && !this.prevIn;
        if (this.prevIn == this.powerLevel > 0) {
            return;
        }
        boolean bl = this.prevIn = this.powerLevel > 0;
        if (pulse) {
            this.injectPearl();
        }
        this.m_6596_();
    }

    private boolean takePearl() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (stack.m_41619_() || !Items.f_42584_.equals(stack.m_41720_()) || stack.m_41613_() <= 0) continue;
            this.items.decrStackSize(i, 1);
            return true;
        }
        return false;
    }

    public void injectPearl() {
        EndergenicTileEntity endergen = this.findEndergenicTileEntity();
        if (endergen != null) {
            if (!this.takePearl()) {
                return;
            }
            int mode = endergen.getChargingMode();
            if (mode != -1) {
                endergen.firePearlFromInjector();
            }
        }
    }

    public void m_142466_(CompoundTag tagCompound) {
        super.m_142466_(tagCompound);
        this.prevIn = tagCompound.m_128471_("prevIn");
    }

    public void m_183515_(@Nonnull CompoundTag tagCompound) {
        super.m_183515_(tagCompound);
        tagCompound.m_128379_("prevIn", this.prevIn);
    }
}

